/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.net.compressed;

import java.io.*;
import java.net.*;

import edu.emory.mathcs.util.net.*;

/**
 * Server socket wrapper that enables data compression on top of connections
 * accepted by a specified server socket. The <code>accept</code>
 * method of this class delegates to the underlying server socket and wraps
 * accepted sockets into {@link CompressedSocketWrapper}.
 *
 * @see CompressedSocketWrapper
 * @see edu.emory.mathcs.util.io.CompressedOutputStream
 *
 * @author Dawid Kurzyniec
 */
public class CompressedServerSocketWrapper extends ServerSocketWrapper
    implements DecoratingServerSocket
{
    protected final int bufSize;
    public CompressedServerSocketWrapper(ServerSocket delegate, int bufSize)
        throws IOException
    {
        super(delegate);
        this.bufSize = bufSize;
    }
    public ServerSocket getBaseSocket() {
        return delegate;
    }

    protected Socket wrapAcceptedSocket(Socket accepted) throws IOException {
        return new CompressedSocketWrapper(accepted, bufSize);
    }
}
